import Utilities.visa_operations as vo
import matplotlib.pyplot as plt
import matplotlib.animation as animation
import matplotlib.backends.backend_tkagg as bt
import tkinter as tk
import numpy as np
import tkinter.filedialog as fd

a = 5
num, delta_t = 50, 1000
t, y = [], []

resource_name = 'USB0::0x0957::0x0607::MY47022122::INSTR'
rm, dmm = vo.open_session(resource_name)

root = tk.Tk()
root.title('Data Logger')
root.geometry('800x600')

def save_data():
    
    fname = fd.asksaveasfilename()
    np.savetxt(fname, np.transpose((t,y)), fmt='%.3f',
                delimiter=',')
    vo.close_session_srq(rm,dmm)
    root.quit()

    return

btn = tk.Button(root, text='Save Data', command=save_data)
btn.pack()

fig, ax = plt.subplots(layout='constrained')
line, = plt.plot(t,y)
canvas = bt.FigureCanvasTkAgg(fig,root)
canvas.get_tk_widget().pack()


def init():
    ax.set_xlim(0, (num-1)*delta_t/1000.)
    ax.set_ylim(-a, a)
    ax.set_xlabel('Time (s)')
    ax.set_ylabel('Voltage (V)')

    return line,

def animate(i,t,y):
    
    t_i = i * delta_t/1000.
    
    command = 'CONF:VOLT:DC 10,0.00001;:INIT;:FETC?'
    vo.write_instrument(dmm, command)
    response = vo.read_instrument(dmm)
    y_i = float(response[:-1])
    
    t.append(t_i)
    y.append(y_i)

    line.set_data(t, y)

    return line,

ani = animation.FuncAnimation(fig,animate,frames=num,
                              fargs=(t,y),interval=delta_t,
                              init_func=init,repeat=False,
                              blit=True)

canvas.draw()

root.mainloop()

